<?php
/**
 * csoft_clearcache back office module for Prestashop >= 1.7
 * Support contact : support@comonsoft.com.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * This source file has been created by Com'onSoft.
 * It is also available through the world-wide-web at this URL:
 * https://boutique.comonsoft.com/
 *
 * @category  back office
 * @package   csoft_clearcache
 * @author    Com'onSoft (https://www.comonsoft.com/)
 * @copyright 2025 Com'onSoft
**/

if (!defined('_PS_VERSION_')) {
    exit;
}

class AdminAjaxcsoft_clearcacheController extends ModuleAdminController
{
	private $assetsCacheDir =  _PS_THEME_DIR_ . 'assets/cache/';
	

    public function postProcess()
    {
        parent::postProcess();
        $action = Tools::getValue('action'); // Get action
        switch ($action) {
            case 'smarty':
                $this->clearSmarty();
                break;
            case 'home':
                $this->clearHome();
                break;
            case 'css':
                $this->clearCSS();
                break;
            case 'js':
                $this->clearJS();
                break;
            case 'cssjs':
                $this->clearCSSJS();
                break;
            default:
                break;
        }
		Tools::redirect($_SERVER['HTTP_REFERER']);
    }

    private function clearSmarty()
    {
        Tools::clearSmartyCache();
    }

    private function clearCSS()
    {
		$cacheDir = $this->assetsCacheDir . '*.css';
		if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') { 	// Under windows
			array_map('unlink', glob($cacheDir, GLOB_NOSORT));
		} else {											// Other OS
			$output=null;
			$retval=null;
			$ret = exec("rm -f $cacheDir", $output, $retval);
		}
        $version = (int) Configuration::get('PS_CCCCSS_VERSION');
        Configuration::updateValue('PS_CCCCSS_VERSION', ++$version);
    }
    private function clearJS()
    {
		$cacheDir = $this->assetsCacheDir . '*.js';
		if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') { 	// Under windows
			array_map('unlink', glob($cacheDir, GLOB_NOSORT));
		} else {											// Other OS
			$output=null;
			$retval=null;
			$ret = exec("rm -f $cacheDir", $output, $retval);
		}
        $version = (int) Configuration::get('PS_CCCJS_VERSION');
        Configuration::updateValue('PS_CCCJS_VERSION', ++$version);
    }

    private function clearCSSJS()
    {
		$this->clearCSS();
		$this->clearJS();
    }

    private function clearHome()
    {
		Tools::clearCache(Context::getContext()->smarty, $this->module->getTemplatePath('index.tpl'));
    }
}
