<?php

/**
 * cs_invisible_recaptcha_v2 front-end module version 1.0.1 for Prestashop 1.6, 1.7
 * Support contact : prestashop@comonsoft.com.
 *
 * NOTICE OF LICENSE
 *
 * This source file is the property of Com'onSoft
 * that is bundled with this package.
 * It is also available through the world-wide-web at this URL:
 * https://boutique.comonsoft.com/
 *
 * @category  front-end
 * @package   cs_invisible_recaptcha_v2
 * @author    Com'onSoft (http://www.comonsoft.com/)
 * @copyright 2016-2018 Com'onSoft and contributors
 * @version   1.0.1
 */

class ContactController extends ContactControllerCore
{
    /**
    * Check reCaptcha response
    */
    public function postProcess()
    {
        if (Tools::isSubmit('submitMessage')) {
            $data = array(
                'secret' => Tools::getValue('RECAPTCHA_PRIVATE_KEY', Configuration::get('RECAPTCHA_PRIVATE_KEY')),
                'response' => $_POST['g-recaptcha-response']
            );
            $verify = curl_init();
            if(isset($verify) && $verify) {
                curl_setopt($verify, CURLOPT_URL, "https://www.google.com/recaptcha/api/siteverify");
                curl_setopt($verify, CURLOPT_POST, true);
                curl_setopt($verify, CURLOPT_POSTFIELDS, http_build_query($data));
                curl_setopt($verify, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($verify, CURLOPT_RETURNTRANSFER, true);
                $response = @curl_exec($verify);
                curl_close($verify);
                $decode = json_decode($response, true);

                if (!$decode['success'] == true) {
                    $this->errors[] = Tools::displayError($this->getTranslator()->trans('You are detected as a robot!', [], 'Shop.Theme.Global'));
                } else {
                    parent::postProcess();
                }

            } else {
                $this->errors[] = Tools::displayError($this->getTranslator()->trans('Error calling Google API.', [], 'Shop.Theme.Global'));
            }
        }
    }
}
