<?php
/**
 * imageregenerator administration module version 1.2 for Prestashop 1.5, 1.6
 * Support contact : prestashop@comonsoft.com.
 *
 * NOTICE OF LICENSE
 *
 * This source file is the property of Jérémy Beson - Com'onSoft
 * that is bundled with this package.
 * It is also available through the world-wide-web at this URL:
 * https://boutique.comonsoft.com/
 *
 * @category  administration
 * @package   imageregenerator
 * @author    Com'onSoft (https://www.comonsoft.com/)
 * @copyright 2026 Com'onSoft and contributors
 * @version   1.2
 */

class imageregeneratorAjaxModuleFrontController extends ModuleFrontController {

    public function initContent()
    {
         // Charger le contexte employee
        $cookie = new Cookie('psAdmin');
        $id_employee = (int)$cookie->id_employee;
        
        // Vérifier que c'est un admin connecté
        if (!$id_employee) {
            header('HTTP/1.1 403 Forbidden');
            die(json_encode(['success' => false, 'error' => 'Unauthorized access']));
        }
        
        $employee = new Employee($id_employee);
        if (!Validate::isLoadedObject($employee) || !$employee->active) {
            header('HTTP/1.1 403 Forbidden');
            die(json_encode(['success' => false, 'error' => 'Unauthorized access']));
        }
        
        // Vérifier le token
        $token = Tools::getValue('image_regenerator_token');
        $expectedToken = Tools::hash('imageregenerator' . $employee->lastname . '-' . $employee->email . _COOKIE_KEY_);
		
        if ($token !== $expectedToken) {
            header('HTTP/1.1 403 Forbidden');
            die(json_encode(['success' => false, 'error' => "Invalid token"]));
        }
        
        parent::initContent();
		$this->module->ajaxProcessRegenerateMethod();
    }
}
?>