<?php
/**
 * Csoft_connectasuser back-end module allows to connect as a customer in front
 * Support contact : prestashop@comonsoft.com.
 *
 * NOTICE OF LICENSE
 *
 * This source file is the property of Com'onSoft
 * that is bundled with this package.
 * It is also available through the world-wide-web at this URL:
 * https://boutique.comonsoft.com/
 *
 * @category  back-end
 * @package   Csoft_connectasuser
 * @author    Com'onSoft (https://www.comonsoft.com/)
 * @copyright 2022. Com'onSoft
 * @version   1.0.0
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

class Csoft_connectasuserLoginModuleFrontController extends ModuleFrontController
{

    public function initContent()
    {
        parent::initContent();

		$id_customer = (int) Tools::getValue('id_customer');

		// Secure login with parameters and token
        if (!Module::isInstalled('csoft_connectasuser') 
			|| !$id_customer 
			|| (
				Tools::getValue('token')!==$this->module->getToken($id_customer) && 
				Tools::getValue('token')!==$this->module->getToken($id_customer, true)
				)
			) {
            Tools::redirect('index.php');
        }

        $customer = new Customer($id_customer);
        if (Validate::isLoadedObject($customer) && $customer->id) {
			$this->context->updateCustomer($customer);
            Tools::redirect('index.php?controller=my-account');
        }
		else {	// Not a valid user or deleted
            Tools::redirect('index.php');
		}
    }
}
