<?php
/**
 * csoft_phpunit  back-end module version 1.0 for Prestashop 1.6, 1.7
 * Support contact : prestashop@comonsoft.com.
 *
 * NOTICE OF LICENSE
 *
 * This source file is the property of Com'onSoft
 * that is bundled with this package.
 * It is also available through the world-wide-web at this URL:
 * https://boutique.comonsoft.com/
 *
 * @category  back-end
 * @package   csoft_phpunit
 * @author    Com'onSoft (http://www.comonsoft.com/)
 * @copyright 2016-2020 Com'onSoft and contributors
 * @version   1.0.0
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

class Csoft_phpunit extends Module
{
    private $module_review_path;
    private $module_controller_url;
    private $product_shop_id;

    public function __construct()
    {
        $this->name = 'csoft_phpunit';
        $this->version = '1.0.2';
        $this->author = 'ComonSoft';
        $this->need_instance = 0;
        $this->bootstrap = true;
        $this->tab = 'administration';
        $this->secure_key = Tools::encrypt($this->name);
        $this->ps_versions_compliancy = [
            'min' => '1.6.0',
            'max' => _PS_VERSION_
        ];

        parent::__construct();

        $this->displayName = $this->l('Test PHPUNIT security hole and fix it in Prestashop');
        $this->description = $this->l('This module detects and removes PHPUNIT folders in Prestashop directory. Secuity hole.');

        $this->module_review_path = _PS_MODULE_DIR_.'/'.$this->name.'/views/templates/admin/post-review-modal.tpl';
        $this->module_controller_url = __PS_BASE_URI__.'module/'.$this->name.'/AddModuleReviews';
        $this->product_shop_id = 31;
        $this->controllers = array('AddModuleReviews');

    }

    public function install()
    {
        if (!parent::install() || !$this->registerHook('displayBackOfficeHeader')) {
            return false;
        }
		Configuration::updateValue('CS_PHPUNIT_REVIEW', 0);
        return true;
    }

    public function uninstall()
    {
        if (!parent::uninstall()) {
            return false;
        }
		Configuration::deleteByName('CS_PHPUNIT_REVIEW');

        return true;
    }

    public function hookDisplayBackOfficeHeader()
    {
        if((strtolower(Tools::getValue('controller')) == 'adminmodules') && (Tools::getValue('configure') == $this->name)) {
            $this->context->controller->addJquery();
            $this->context->controller->addCSS(dirname(__FILE__).'/views/css/productcomments.css');
            $this->context->controller->addJS(dirname(__FILE__).'//views/js/jquery.rating.plugin.js');
            $this->context->controller->addJS(dirname(__FILE__).'/views/js/post-comment.js');
        }
    }

    public function getContent()
    {
        $rii = new RecursiveIteratorIterator(new RecursiveDirectoryIterator(_PS_ROOT_DIR_, FilesystemIterator::SKIP_DOTS));

        $phpunitfolder = array();
        $hackFiles = array();
        $hackFilesNames = array('XsamXadoo_Bot.php','XsamXadoo_deface.php','0x666.php','f.php');
		
        foreach ($rii as $file) {
            if($file->isFile()){
                foreach ($hackFilesNames as $hackFilesName) {
                    if($file->getFilename()==$hackFilesName) {
						if (Tools::isSubmit('submitCsoft_phpunit'))
						{
	                        $hackFiles[] =  $file->getPathname().' <i class="icon-check" style="color:green" ></i>';
							Tools::deleteFile($file->getPathname());
						}
						else {
	                        $hackFiles[] =  $file->getPathname().' <i class="icon-remove" style="color:red" ></i>';
						}
					}
                }
            }
            if ($file->isDir() && $file->getFilename()=='.' && strpos($file->getPathname(), 'vendor/phpunit/.') !== false) {
				if (Tools::isSubmit('submitCsoft_phpunit'))
				{
	                Tools::deleteDirectory(substr($file->getPathname(), 0, -1));
	                $phpunitfolder[] = substr($file->getPathname(), 0, -1).' <i class="icon-check" style="color:green" ></i>';
				}
				else {
	                $phpunitfolder[] =substr($file->getPathname(), 0, -1).' <i class="icon-remove" style="color:red" ></i>';
				}
            }
        }

        $this->context->smarty->assign(
            array(
                'hackFiles' => $hackFiles,
                'phpunitfolder' => $phpunitfolder,
				'actionmsg' => (Tools::isSubmit('submitCsoft_phpunit')?$this->l('Files and folders successfully deleted.'):'')
            )
        );

        $this->smarty->assign(array('moduleName' => $this->displayName, 'customer_name' => $this->context->employee->firstname.' '.substr($this->context->employee->lastname,0,1).'.','module_review_path' => $this->module_review_path,'product_shop_id' => $this->product_shop_id, 'module_controller_url' => $this->module_controller_url));

        return $this->display(__FILE__, 'views/templates/admin/infos.tpl').$this->display(__FILE__, 'views/templates/admin/admin.tpl');
    }

}
