<?php

class Csoft_birthday_control extends Module
{
  public function __construct()
  {
    $this->name                   = 'csoft_birthday_control';
    $this->version                = '1.0.2';
    $this->author                 = 'ComonSoft';
    $this->bootstrap              = true;
    $this->module_review_path = _PS_MODULE_DIR_ . '/' . $this->name . '/views/templates/admin/post-review-modal.tpl';
    $this->module_controller_url = __PS_BASE_URI__ . 'module/' . $this->name . '/AddModuleReviews';
    $this->product_shop_id = 46;
    $this->ps_versions_compliancy = array(
      'min' => '1.7.0',
      'max' => _PS_VERSION_
    );
    parent::__construct();
    $this->displayName            = $this->l('Birthday date verification');
    $this->description            = $this->l('Limit customer inscription from age range, checks whether the date of birth field is in date format and define if birthday field is required or not');
  }

  public function install()
  {
    return parent::install()
      && Configuration::updateValue('CSOFT_AGE_MIN', 18)
      && Configuration::updateValue('CSOFT_AGE_MAX', 92)
      && Configuration::updateValue('CSOFT_REQBIRTHDAY', 0)
      && $this->registerHook('additionalCustomerFormFields')
      && $this->registerHook('displayBackOfficeHeader');
  }

  public function uninstall()
  {

    return parent::uninstall()
      && Configuration::deleteByName('CSOFT_AGE_MIN')
      && Configuration::deleteByName('CSOFT_AGE_MAX')
      && Configuration::deleteByName('CSOFT_REQBIRTHDAY');
  }

  public function getContent()
  {
    $output = null;

    if (Tools::isSubmit('btnSubmit')) {
      $ageMin = trim(strval(Tools::getValue('CSOFT_AGE_MIN')));
      $ageMax = trim(strval(Tools::getValue('CSOFT_AGE_MAX')));

      if (!$ageMin || empty($ageMin) || !$ageMax || empty($ageMax) || (int)($ageMin) != $ageMin ||  (int)($ageMax) != $ageMax || !(is_numeric($ageMin) || !(is_numeric($ageMax)))) {
        $output .= $this->displayError($this->l('Invalid Configuration value'));
      } else if ((int)$ageMin >= (int)$ageMax) {
        $output .= $this->displayError($this->l('The minimum age cannot be greater than or equal to the maximum age'));
      } else {
        Configuration::updateValue('CSOFT_AGE_MIN', abs($ageMin));
        Configuration::updateValue('CSOFT_AGE_MAX', abs($ageMax));
        Configuration::updateValue('CSOFT_REQBIRTHDAY', Tools::getValue('CSOFT_REQBIRTHDAY'));
        $output .= $this->displayConfirmation($this->l('Settings updated'));
      }
    }

    return $output . $this->displayForm();
  }

  public function displayForm()
  {
    // Default language
    $defaultLang = (int)Configuration::get('PS_LANG_DEFAULT');

    // Initialise formfield in array
    $form = array(
      'form' => array(
        'legend' => array(
          'title' => $this->l('Settings'),
        ),
        'input' => array(
          array(
            'type' => 'text',
            'label' => $this->l('Age minimum'),
            'name' => 'CSOFT_AGE_MIN',
            'size' => 20,
            'required' => true
          ),
          array(
            'type' => 'text',
            'label' => $this->l('Age maximum'),
            'name' => 'CSOFT_AGE_MAX',
            'size' => 20,
            'required' => true
          ),
          array(
            'type' => 'switch',
            'label' => $this->l('Require birthday:'),
            'name' => 'CSOFT_REQBIRTHDAY',
            'values' => array(
              array(
                'id' => 'birthday_on',
                'value' => 1,
                'label' => $this->l('Yes')
              ),
              array(
                'id' => 'birthday_off',
                'value' => 0,
                'label' => $this->l('No')
              ),
            ),
          ),
        ),
        'submit' => array(
          'title' => $this->l('Save'),
          'name'  => 'btnSubmit'
        )
      ),
    );

    $helper = new HelperForm();

    // Module, token and currentIndex
    $helper->module = $this;
    $helper->name_controller = $this->name;
    $helper->token = Tools::getAdminTokenLite('AdminModules');
    $helper->currentIndex = AdminController::$currentIndex . '&configure=' . $this->name;

    // Langue
    $helper->default_form_language = $defaultLang;

    // value
    $helper->fields_value['CSOFT_AGE_MIN']     = Configuration::get('CSOFT_AGE_MIN');
    $helper->fields_value['CSOFT_AGE_MAX']     = Configuration::get('CSOFT_AGE_MAX');
    $helper->fields_value['CSOFT_REQBIRTHDAY'] = Configuration::get('CSOFT_REQBIRTHDAY');

    return $this->_displayInfos() . $helper->generateForm(array($form));
  }

  private function _displayInfos()
  {
    $this->smarty->assign(array('moduleName' => $this->displayName, 
								'customer_name' => $this->context->employee->firstname . ' ' . substr($this->context->employee->lastname, 0, 1) . '.', 
								'module_review_path' => $this->module_review_path, 
								'product_shop_id' => $this->product_shop_id, 
								'domain' => urlencode(Context::getContext()->shop->getBaseURL(true)),
								'module_controller_url' => $this->module_controller_url));

    return $this->display(__FILE__, 'views/templates/admin/infos.tpl');
  }

  /*
		We use this hook just to set the field birdthday required 
		if required by user configuration.
	*/
  public function hookAdditionalCustomerFormFields($params)
  {

	if( isset($params['fields']) ) {
		$format = $params['fields'];
		if (isset($format['birthday']) && Configuration::get('CSOFT_REQBIRTHDAY')) {
		  $format['birthday']->setRequired(true);
		}
	}

    return null;
  }

  public function hookDisplayBackOfficeHeader()
  {
        if (Tools::getValue('configure') == $this->name) {
          $this->context->controller->addCSS($this->getPathUri() . '/views/css/productcomments.css');
          $this->context->controller->addJS($this->getPathUri() . '/views/js/jquery.rating.plugin.js');
          $this->context->controller->addJS($this->getPathUri() . '/views/js/post-comment.js');
      }
  }
}
