<?php
/**
 * Csoft_connectasuser back-end module allows to connect as a customer in front
 * Support contact : prestashop@comonsoft.com.
 *
 * NOTICE OF LICENSE
 *
 * This source file is the property of Com'onSoft
 * that is bundled with this package.
 * It is also available through the world-wide-web at this URL:
 * https://boutique.comonsoft.com/
 *
 * @category  back-end
 * @package   Csoft_connectasuser
 * @author    Com'onSoft (https://www.comonsoft.com/)
 * @copyright 2022. Com'onSoft
 * @version   1.0.0
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

use PrestaShop\PrestaShop\Core\Action\ActionsBarButton;

class Csoft_connectasuser extends Module
{
    private $product_shop_id;
    private $module_review_path;
    private $module_controller_url;
	

    public function __construct()
    {
        $this->name = 'csoft_connectasuser';
        $this->tab = 'administration';
        $this->version = '1.1.0';
        $this->author = 'ComonSoft';
        $this->need_instance = 0;
        $this->bootstrap = true;
		$this->ps_versions_compliancy = array('min' => '1.7', 'max' => _PS_VERSION_);

        $this->module_review_path = _PS_MODULE_DIR_ . '/' . $this->name . '/views/templates/admin/post-review-modal.tpl';
        $this->module_controller_url = __PS_BASE_URI__ . 'module/' . $this->name . '/AddModuleReviews';
        $this->product_shop_id = 52;

        parent::__construct();
        $this->displayName = $this->l('Connect as customer');
        $this->description = $this->l('Allows you to connect on front as the chosen customer account.');
    }

    public function install()
    {
		$token = md5( str_shuffle( chr(rand(33,254)).
									chr(rand(33,254)).
									date('Ymd').
									chr(rand(33,254)).
									__PS_BASE_URI__.
									chr(rand(33,254)).
									chr(rand(33,254)) 
								)
					);

        return parent::install()
			&& $this->registerHook('displayBackOfficeHeader')
            && $this->registerHook('displayAdminOrderLeft')
			&& $this->registerHook('displayAdminOrderSideBottom')
            && $this->registerHook('actionGetAdminOrderButtons')
            && $this->registerHook('displayAdminCustomers')
			&& Configuration::updateValue('CS_CONNECTASUSER_KEY', $token);
    }

    public function uninstall()
    {
        return parent::uninstall() && Configuration::deleteByName('CS_CONNECTASUSER_KEY');
    }

    public function getContent()
    {
	    $this->smarty->assign(array('customer_name' => $this->context->employee->firstname . ' ' . substr($this->context->employee->lastname, 0, 1) . '.', 
								'module_review_path' => $this->module_review_path, 
								'product_shop_id' => $this->product_shop_id, 
								'domain' => urlencode(Context::getContext()->shop->getBaseURL(true)),
								'module_controller_url' => $this->module_controller_url));
        
        return $this->display(__FILE__, 'views/templates/admin/infos.tpl');;
    }

  public function hookDisplayBackOfficeHeader($params)
  {
    if (Tools::getValue('configure') == $this->name) {
      if(method_exists($this->context->controller, 'addJquery')) {
          $this->context->controller->addJquery();
      }
      $this->context->controller->addCSS($this->getPathUri(). 'views/css/productcomments.css');
      $this->context->controller->addJS($this->getPathUri() . 'views/js/jquery.rating.plugin.js');
      $this->context->controller->addJS($this->getPathUri() . 'views/js/post-comment.js');
    }
  }

    public function hookDisplayAdminCustomers($params)
    {
		$html = '';

        $id_customer = (int) $params['id_customer'];
        $customer = new Customer($id_customer);

        if (Validate::isLoadedObject($customer) && $customer->id) {
			$connect_link = $this->getLinkUrl($id_customer);
			$this->context->smarty->assign(array('login_url' => $connect_link));
			$html = $this->display(__FILE__, 'views/templates/admin/loginbutton_cust.tpl');
		}

		return $html;

    }


	/* Since 1.7.7 */
	public function hookDisplayAdminOrderSideBottom($params) {

		return $this->hookdisplayAdminOrderLeft($params);
	}

	public function hookdisplayAdminOrderLeft($params)
	{
		$html = '';
		if (version_compare(_PS_VERSION_, '1.7.7', '<')) {	// If PS >= 1.7.7 use hookActionGetAdminOrderButtons
			$order = new Order((int) $params['id_order']);
			if (Validate::isLoadedObject($order)) {
				$connect_link = $this->getLinkUrl($order->id_customer);
				$this->context->smarty->assign(array('login_url' => $connect_link));
		
				// Since Ps 1.7.7 the template changed
				if (version_compare(_PS_VERSION_, '1.7.7', '>=')) {
					$html = $this->display(__FILE__, 'views/templates/admin/loginbutton-177.tpl');
				}
				else {
					$html = $this->display(__FILE__, 'views/templates/admin/loginbutton.tpl');
				}
			}
		}

		return $html;
	}


    /**
     * Add button to main buttons bar Since 1.7.7
     */
    public function hookActionGetAdminOrderButtons(array $params)
    {
        $order = new Order($params['id_order']);
        if (Validate::isLoadedObject($order)) {
            $connect_link = $this->getLinkUrl($order->id_customer);

            $bar = $params['actions_bar_buttons_collection'];
			
			if (version_compare(_PS_VERSION_, '9.0.0', '>=')) {	// If PS >= 9.0.0 use ActionsBarButton instead of \PrestaShopBundle\Controller\Admin\Sell\Order\ActionsBarButton
				$bar->add(
					new ActionsBarButton(
						'btn-action', ['href' => $connect_link, 'target' => '_blank'], '<i class="material-icons">person</i> '.$this->l( 'Connect as user')
					)
				);
			}
			else {
				$bar->add(
					new \PrestaShopBundle\Controller\Admin\Sell\Order\ActionsBarButton(
						'btn-action', ['href' => $connect_link, 'target' => '_blank'], '<i class="material-icons">person</i> '.$this->l( 'Connect as user')
					)
				);
			}
        }
    }

	private function getLinkUrl( $id_customer) {
		$login_url = $this->context->link->getModuleLink(
				'csoft_connectasuser',
				'Login',
			   [
					'id_customer' => $id_customer,
					'token' => $this->getToken($id_customer)
			   ]
			);

		return $login_url;
	}
	
	/*
		Generate a token, valid until one hour
	*/
	public function getToken($id_customer, $hour=false) {
		if( $hour ) {
			$token = md5( Configuration::get('CS_CONNECTASUSER_KEY').$id_customer.date('YmdH', strtotime('-1 hour')));
		}
		else {
			$token = md5( Configuration::get('CS_CONNECTASUSER_KEY').$id_customer.date('YmdH'));
		}
		
		return $token;
	}

}
