{*
 * csoft_phpunit  back-end module version 1.0 for Prestashop 1.6, 1.7
 * Support contact : prestashop@comonsoft.com.
 *
 * NOTICE OF LICENSE
 *
 * This source file is the property of Com'onSoft
 * that is bundled with this package.
 * It is also available through the world-wide-web at this URL:
 * https://boutique.comonsoft.com/
 *
 * @category  back-end
 * @package   csoft_phpunit
 * @author    Com'onSoft (http://www.comonsoft.com/)
 * @copyright 2016-2020 Com'onSoft and contributors
 * @version   1.0.0
*}
<div class="panel">
    <div class="panel-heading"> <i class="icon-question"></i> {l s='Help'} </div>
    <div class="bootstrap form-wrapper">
        {l s='Official alert information is available' mod='csoft_phpunit'} <a href="https://build.prestashop.com/news/critical-security-vulnerability-in-prestashop-modules/" target="_blank">{l s='here' mod='csoft_phpunit'}</a><br />
	</div>
</div>
<div class="panel">
    <div class="panel-heading"> <i class="icon-wrench"></i> {l s='Tools' mod='csoft_phpunit'} </div>
    <div class="bootstrap form-wrapper">
    {if $hackFiles}
        <table class="table table-striped">
            <thead>
                <tr>
                    <th><strong>{l s='Your Prestashop appears to be compromised, please delete following files immediately!' mod='csoft_phpunit'}</strong></th>
                </tr>
            </thead>
            <tbody>
            {foreach from=$hackFiles item=f}
                <tr>
                    <td>{$f}</td>
                </tr>
            {/foreach}
            </tbody>
        </table>
	{else}
        <p class="alert alert-success">
            {l s='Your Prestashop appears not to have been compromised.' mod='csoft_phpunit'}
        </p>
    {/if}
    {if $phpunitfolder}
        <table class="table table-striped">
            <thead>
                <tr>
                    <th><strong>{l s='Potential hole found in' mod='csoft_phpunit'}</strong></th>
                </tr>
            </thead>
            <tbody>
                    {foreach from=$phpunitfolder item=f}
                        <tr>
                            <td>{$f}</td>
                        </tr>
                    {/foreach}
            </tbody>
        </table>
        {else}
            <p class="alert alert-success">
                {l s='No vendor/phpunit folder found in modules PrestaShop directory. Your Prestashop appears to be safe.' mod='csoft_phpunit'}
            </p>
        {/if}
    	{if ($phpunitfolder || $hackFiles) && $actionmsg==''}
        <form action="{$smarty.server.REQUEST_URI}" name="csoft_phpunit" method="post" class="form-horizontal">
			<div class="panel-footer">
              <button type="submit" value="1" id="module_form_submit_btn" name="submitCsoft_phpunit" class="btn btn-default pull-right"> <i class="process-icon-delete"></i> {l s="Delete files and folders" mod='csoft_phpunit'} </button>
            </div>
		</form>
       {/if}
       {if $actionmsg}
            <p class="alert alert-success">
                {$actionmsg}
            </p>
       {/if}
	</div>
</div>
