<?php

class Validate extends ValidateCore
{

    /**
     * Check for birthDate validity.
     *
     * @param string $date birthdate to validate
     * @param string $format optional format
     *
     * @return bool Validity is ok or not
     */
    public static function isBirthDate($date, $format = 'Y-m-d')
    {
        if (empty($date) || $date == '0000-00-00') {
            return true;
        }
        
        $today  = new DateTime();
        $newDate = date("Y-m-d", strtotime($date));
        $birth  = new DateTime($newDate);
        $diff   = $today->diff($birth);
        $delta  = $diff->format('%y');

        $ageMin = Configuration::get('CSOFT_AGE_MIN');
        $ageMax = Configuration::get('CSOFT_AGE_MAX');

        $d = DateTime::createFromFormat($format, $date);
        if (!empty(DateTime::getLastErrors()['warning_count']) || false === $d || $delta > $ageMax || $delta < $ageMin) {
            return false;
        }

        return $d->getTimestamp() <= time();
    }

}






?>