<?php
/**
 * csoft_instagramfeeds front-end module version 1.3.4 for Prestashop 1.6, 1.7
 * Support contact : prestashop@comonsoft.com.
 *
 * NOTICE OF LICENSE
 *
 * This source file is the property of Com'onSoft
 * that is bundled with this package.
 * It is also available through the world-wide-web at this URL:
 * https://boutique.comonsoft.com/
 *
 * @category  front-end
 * @package   csoft_instagramfeeds
 * @author    Com'onSoft (http://www.comonsoft.com/)
 * @copyright 2016-2020 Com'onSoft and contributors
 * @version   1.4.45
 */

class csoft_instagramfeeds extends Module
{
    private $module_review_path;
    private $module_controller_url;
    private $product_shop_id;
	private $metaAppId       = '521929624335441';
	private $metaAuthUrl     = 'https://www.instagram.com/oauth/authorize';
	private $metaRedirecrUtl = 'https://www.comonsoft.com/api/access-token-free.php';

    public function __construct()
    {
        $this->name = 'csoft_instagramfeeds';
        $this->version = '1.7.2';
        $this->author = 'ComonSoft';
        $this->bootstrap = true;
        parent::__construct();
        $this->ps_versions_compliancy = array('min' => '1.6', 'max' => _PS_VERSION_);
        $this->displayName = $this->l('Instagram latest photos on home page');
        $this->description = $this->l('Display latest published photos from an Instagram account. Use Instagram API.');

        if (floatval(_PS_VERSION_) < 1.7 ) {
	        $this->controllers = array('AddModuleReviews');
		}

        $this->bootstrap = 1;
        $this->module_review_path = _PS_MODULE_DIR_.'/'.$this->name.'/views/templates/admin/post-review-modal.tpl';
        $this->module_controller_url = __PS_BASE_URI__.'module/'.$this->name.'/AddModuleReviews';
        $this->product_shop_id = 18;

		$accessToken = Configuration::get('CS_INS_CT');
		if( strlen($accessToken) == 0 ) {
			$this->warning = $this->l('This module needs to be configured to work properly!');
		}
    }

    public function install()
    {
        if (!extension_loaded('curl')) {
            $this->_errors[] = Tools::displayError($this->l('You need a PHP curl extension for use this module'));
            return false;
        }

        return parent::install() &&
        Configuration::updateValue('CS_INS_ID', 'xxxxxxxxxx') &&
        Configuration::updateValue('CS_INS_CT', '') &&
        Configuration::updateValue('CS_NB_IMAGE', 20) &&
        Configuration::updateValue('CS_SIZE', 170) &&
        Configuration::updateValue('CS_CACHE_DURATION', 'day') &&
        Configuration::updateValue('CS_INS_REVIEW', 0) &&
        $this->registerHook('displayHome') &&
        $this->registerHook('actionAdminControllerSetMedia') &&
        $this->registerHook('displayHeader')&&
        $this->registerHook('displayBackOfficeHeader');
    }

    public function uninstall()
    {
        Configuration::deleteByName('CS_INS_ID');
        Configuration::deleteByName('CS_INS_USER');
        Configuration::deleteByName('CS_INS_CT');
        Configuration::deleteByName('CS_NB_IMAGE');
        Configuration::deleteByName('CS_SIZE');
        Configuration::deleteByName('CS_CACHE_DURATION');
        Configuration::deleteByName('CS_INS_REVIEW');
        return parent::uninstall();
    }

    public function hookDisplayBackOfficeHeader()
    {
        if((strtolower(Tools::getValue('controller')) == 'adminmodules') && (Tools::getValue('configure') == $this->name)) {
			if(method_exists($this->context->controller, 'addJquery')) {
            	$this->context->controller->addJquery();
			}
            $this->context->controller->addCSS($this->getPathUri().'views/css/productcomments.css');
            $this->context->controller->addJS($this->getPathUri().'views/js/jquery.rating.plugin.js');
            $this->context->controller->addJS($this->getPathUri().'views/js/post-comment.js');
            $this->context->controller->addJS($this->getPathUri().'views/js/cs_instagram_config.js');
        }
    }

    public function hookDisplayHeader($params)
    {
        if (floatval(_PS_VERSION_) >= 1.6 && floatval(_PS_VERSION_) < 1.7) {
            $this->context->controller->addJS('modules/'.$this->name.'/views/js/cs_instagram.js');
            $this->context->controller->addCSS('modules/'.$this->name.'/views/css/cs_instagram.css');
        } elseif (floatval(_PS_VERSION_) >= 1.7) {
            $this->context->controller->registerJavascript('cs_instagram_js', 'modules/'.$this->name.'/views/js/cs_instagram.js');
            $this->context->controller->registerStylesheet('cs_instagram_css', 'modules/'.$this->name.'/views/css/cs_instagram.css');
            $this->requireAssets(array('font-awesome'));
        }
        $this->context->controller->addJqueryPlugin('bxslider');
        Media::addJsDef(array('slider_width' => Configuration::get('CS_SIZE')));
    }

    public static function my_parse_query($str)
    {
        if (($champs = explode('&', $str)) === false) {
            return array();
        }
        $resultat = array();
        foreach ($champs as $champ) {
            if (($zone = explode('=', $champ, 2)) === false) {
                $nom = urldecode($champ);
                $valeur = '';
            } else {
                $nom = urldecode($zone[0]);
                if (isset($zone[1])) {
                    $valeur = urldecode($zone[1]);
                } else {
                    $valeur = '';
                }
            }
            if (empty($resultat[$nom])) {
                $resultat[$nom] = $valeur;
            } elseif (!empty($valeur)) {
                $resultat[$nom] .= ' ' . $valeur;
            }
        }
        return $resultat;
    }

    public function getContent()
    {
		$warning_ext = '';
		$msg = $this->_postProcess();

        $request_uri = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ?
                "https" : "http") . "://" . $_SERVER['HTTP_HOST'] .
            $_SERVER['REQUEST_URI'];

        $params_uri = self::my_parse_query($request_uri);

        $expl_request_uri = explode('&', $request_uri);

		if( Tools::getValue('token') ) {
			$tokenStr = Tools::getValue('token');;
		}
		else {
			$tokenStr = Tools::getValue('_token');;
		}
        $insta_return_uri = substr($expl_request_uri[0], 0, -23).'token-'.$tokenStr.'|csoft_instagramfeeds';

        $insta_get_code_uri = $this->metaAuthUrl.'?client_id='.$this->metaAppId.'&redirect_uri='.$this->metaRedirecrUtl.'&response_type=code&enable_fb_login=0&scope=instagram_business_basic&state='.$insta_return_uri;

		if (!Tools::isSubmit('deleteAccount')) {
			$accessToken = trim(strval(Tools::getValue('accessToken')));
			if ($accessToken && !empty($accessToken) && Validate::isGenericName($accessToken)) {
				Configuration::updateValue('CS_INS_CT', $accessToken);
				$instagram_account_info = $this->getAccountInfos();
				Configuration::updateValue('CS_INS_ID', $instagram_account_info['id']);
				Configuration::updateValue('CS_INS_USER', $instagram_account_info['username']);
			}
		}

		if (Configuration::get('CS_INS_ID') && Configuration::get('CS_INS_USER')) {
            $js_def = array(
                'account_infos' => Configuration::get('CS_INS_ID'),
                'account_infos_label' => $this->l('The module is now authorised to access photos of this following Instagram account:'),
                'account_infos_btn' => $this->l(' Remove access'),
                'account_infos_username' => $this->l(sprintf('Username: %s', Configuration::get('CS_INS_USER'))),
            );
         	$this->smarty->assign( $js_def); 
		}

        $this->smarty->assign( array('moduleName' => $this->displayName, 
									'customer_name' => $this->context->employee->firstname.' '.substr($this->context->employee->lastname,0,1).'.',
									'module_review_path' => $this->module_review_path,
									'product_shop_id' => $this->product_shop_id, 
									'module_controller_url' => $this->module_controller_url,
									'domain' => urlencode(Context::getContext()->shop->getBaseURL(true)),
									'submit_account_url' => $insta_get_code_uri, 
									'insta_btn_label' => $this->l('Click button to authorize the module to access your Instagram photos:'),
									'insta_btn_title' => '&nbsp;'.$this->l(' Connect to your Instagram account'
									))
							);

        return $this->display(__FILE__, 'views/templates/admin/infos.tpl') . $warning_ext . $msg . $this->_getForm();
    }

    private function _postProcess()
    {
        $output = false;

        if (Tools::isSubmit('deleteAccount')) {
            Configuration::deleteByName('CS_INS_ID');
            Configuration::deleteByName('CS_INS_USER');
            Configuration::deleteByName('CS_INS_CT');
            Tools::clearCache(null, 'csInstagramFeeds.tpl', Configuration::get('CS_INS_ID'));
            Tools::clearCache(Context::getContext()->smarty, $this->getTemplatePath('index.tpl'));
            return $output = $this->displayConfirmation($this->l('Settings updated'));
        }

        $error = trim(strval(Tools::getValue('error')));
        if ($error && !empty($error) && Validate::isGenericName($error)) {
            $output = $this->displayError($error);
        }

        $accessToken = trim(strval(Tools::getValue('accessToken')));
        if ($accessToken && !empty($accessToken) && Validate::isGenericName($accessToken)) {
            Configuration::updateValue('CS_INS_CT', $accessToken);
            $instagram_account_info = $this->getAccountInfos();
            Configuration::updateValue('CS_INS_ID', $instagram_account_info['id']);
            Configuration::updateValue('CS_INS_USER', $instagram_account_info['username']);
            $output .= $this->displayConfirmation($this->l('Settings updated'));
            Tools::clearCache(null, 'csInstagramFeeds.tpl', Configuration::get('CS_INS_ID'));
            Tools::clearCache(Context::getContext()->smarty, $this->getTemplatePath('index.tpl'));
        }

        if (Tools::isSubmit('subMOD')) {
            if (Validate::isInt(Tools::getValue('nb_image')) && Tools::getValue('nb_image') >= 1) {
                Configuration::updateValue('CS_NB_IMAGE', intval(Tools::getValue('nb_image')));
            } else {
                $output.= $this->displayError($this->l('Number of images must be a number'));
            }

            if (Validate::isInt(Tools::getValue('size'))) {
                Configuration::updateValue('CS_SIZE', intval(Tools::getValue('size')));
            } else {
                $output.= $this->displayError($this->l('Size field value must be a number'));
            }

            $cache_duration = trim(strval(Tools::getValue('cache_duration')));
            if ($cache_duration && !empty($cache_duration) && Validate::isGenericName($cache_duration)) {
                Configuration::updateValue('CS_CACHE_DURATION', $cache_duration);
            } else {
                $output.= $this->displayError($this->l('Cache duration field is required'));
            }

            $access_token = trim(strval(Tools::getValue('access_token')));
            if ($access_token && !empty($access_token) && Validate::isGenericName($access_token)) {
                Configuration::updateValue('CS_INS_CT', Tools::getValue('access_token'));
            }

            if (!$output) {
                $output = $this->displayConfirmation($this->l('Settings updated'));
				        $conf = Configuration::getMultiple(array('CS_INS_ID', 'CS_CACHE_DURATION'));

        $cacheIdDate = $conf['CS_CACHE_DURATION'] == 'day' ? date('Ymd') : date('YmdH');
        $cache_array = array($this->name, $conf['CS_INS_ID'], $cacheIdDate, (int)$this->context->language->id);
        $cacheId = implode('|', $cache_array);

				Tools::clearCache(null, 'csInstagramFeeds.tpl', $cacheId);
				Tools::clearCache(Context::getContext()->smarty, $this->getTemplatePath('index.tpl'));
            }
        }
        if (Tools::isSubmit('subTEST')) {
			$instaflux = $this->getFeed();
			$output = $this->displayConfirmation($this->l('Returned Instagram data :').'<br>'.json_encode($instaflux));
        }

        if ($output) {
            return $output;
        }
    }

    private function _getForm()
    {
        $helper = new HelperForm();
        $helper->module = $this;
        $helper->name_controller = $this->name;
        $helper->identifier = $this->identifier;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->languages = $this->context->controller->getLanguages();
        $helper->currentIndex = AdminController::$currentIndex . '&configure=' . $this->name;
        $helper->default_form_language = (int) Configuration::get('PS_LANG_DEFAULT');
		if( isset($helper->allow_employee_form_lang) ) {
	        $helper->allow_employee_form_lang = $this->context->controller->allow_employee_form_lang;
		}
        $helper->title = $this->displayName;
        $helper->fields_value['access_token'] = Configuration::get('CS_INS_CT');
        $helper->fields_value['nb_image'] = Configuration::get('CS_NB_IMAGE');
        $helper->fields_value['size'] = Configuration::get('CS_SIZE');
        $helper->fields_value['cache_duration'] = Configuration::get('CS_CACHE_DURATION');
        $helper->fields_value['switch_access_token'] = 0;
		

        $helper->submit_action = 'subMOD';

        # form
        $this->fields_form[] = array(
            'form' => array(
                'legend' => array(
                    'title' => $this->displayName,
                ),
                'input' => array(
                    array(
                        'type' => 'switch',
                        'label' => $this->l('Enter your Instagram Access Token manually:'),
                        'name' => 'switch_access_token',
                        'values' => array(
                            array(
                                'id' => 'switch_access_token_on',
                                'value' => 1,
                                'label' => $this->l('Yes')
                            ),
                            array(
                                'id' => 'switch_access_token_off',
                                'value' => 0,
                                'label' => $this->l('No')
                            ),
                        ),
                    ),
                     array(
                        'type' => 'text',
                        'label' => $this->l('Instagram Access Token:'),
                        'name' => 'access_token',
                        'id' => 'access_token',
                        'desc'  => $this->l('Fill in your access token')
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Image number:'),
                        'required' => true,
                        'name' => 'nb_image'
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Resize size in pixel :'),
                        'name' => 'size',
                    ),
                    array(
                        'type' => 'select',
                        'name' => 'cache_duration',
                        'label' => $this->l('Refresh :'),
                        'options' => array(
                            'query' => array(
                                array('id' => 'day', 'name' => $this->l('Each day')),
                                array('id' => 'hour', 'name' => $this->l('Each hour'))
                            ),
                            'id' => 'id',
                            'name' => 'name'
                        )
                    )
                ),
                'buttons' => array(
                    'submit' => array(
                        'title' => $this->l('Save'),
                        'name' => 'subMOD',
                        'type' => 'submit',
                        'id' => 'configuration_form_submit_btn',
                        'class' => 'btn btn-default pull-right',
                        'icon' => 'process-icon-save',
                    )
                )
            ),
        );

		$accessToken = Configuration::get('CS_INS_CT');
		if ($accessToken && !empty($accessToken)) {
			$this->fields_form[] = array(
				'form' => array(
					'legend' => array(
						'title' => $this->l('Test Instagram feed'),
					),
					'buttons' => array(
						'submit2' => array(
							'title' => $this->l('Test'),
							'name' => 'subTEST',
							'type' => 'submit',
							'id' => 'configuration_form_submit_btn',
							'class' => 'btn btn-default pull-right',
							'icon' => 'process-icon-preview',
						)
					)
				)
			);
		}

        return $helper->generateForm($this->fields_form);
    }

    public function hookDisplayHome($params)
    {
		$accessToken = Configuration::get('CS_INS_CT');
		if( strlen($accessToken) > 1 ) {
			$cacheStr = '<!-- Cached -->';
			$conf = Configuration::getMultiple(array('CS_INS_ID', 'CS_CACHE_DURATION'));
	
			$cacheIdDate = $conf['CS_CACHE_DURATION'] == 'day' ? date('Ymd') : date('YmdH');
			$cache_array = array($this->name, $conf['CS_INS_ID'], $cacheIdDate, (int)$this->context->language->id);
			$cacheId = implode('|', $cache_array);
	
			if (Configuration::get('CS_SIZE') > 0) {
				$width_slider = Configuration::get('CS_SIZE');
			}
			else
				$width_slider = 170;
	
			Media::addJsDef(array('slider_width' => $width_slider));
	
			if (!$this->isCached('csInstagramFeeds.tpl', $cacheId)) {
				$cacheStr = '<!-- Not cached -->';
				$this->context->smarty->assign(array(
					'instagram_pics' => $this->getPics(),
					'imagewidth' => $width_slider,
					'imageheight' => (int)($width_slider / 0.8)
				));
			}
	
			return $cacheStr . $this->display(__FILE__, 'csInstagramFeeds.tpl', $cacheId);
		}
		return '';
    }

	/*
		Refresh long live token
		See doc : https://developers.facebook.com/docs/instagram-basic-display-api/guides/long-lived-access-tokens
	*/
    private function getLongAccessToken()
	{
        $api = 'https://graph.instagram.com/refresh_access_token?grant_type=ig_refresh_token&access_token='.Configuration::get('CS_INS_CT') ;
        $ch = curl_init($api);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $json = curl_exec($ch);
        $result = json_decode($json);
        curl_close($ch);
		// We have a new one token, save it
        if( isset($result->access_token) && $result->access_token) {
			Configuration::updateValue('CS_INS_CT', $result->access_token);
		}
	}

    public function getFeed()
    {
		$this->getLongAccessToken();
        $access_token = Configuration::get('CS_INS_CT');
        $nb = Configuration::get('CS_NB_IMAGE');
        $url = 'https://graph.instagram.com/me/media?fields=caption,media_type,media_url,username,timestamp,permalink,comments_count,like_count&access_token='.$access_token.'&limit='.$nb;
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $json = curl_exec($ch);
        curl_close($ch);

        return json_decode($json, true);
    }

    public function getPics()
    {
        $conf = Configuration::getMultiple(array('CS_NB_IMAGE', 'CS_SIZE'));

        $instagram_pics = array();
        $values = $this->getFeed();

        if (!$values || (isset($values['meta']['error_message']) && $values['meta']['error_message'])) {
            return array();
        }

        $items = array_slice($values['data'], 0, $conf['CS_NB_IMAGE']);
        foreach ($items as $item) {
			if(  $item["media_type"]==='IMAGE' || $item["media_type"]==='CAROUSEL_ALBUM') {
				$instagram_pics[] = array(
					'image' => $item['media_url'],
					'caption' => isset($item['caption']) ? str_replace(["\r", "\n"], ' ', $item['caption']) : '',
					'link' =>  $item['permalink'],
					'comments' => $item['comments_count'],
					'like' =>  $item['like_count']
				);
			}
        }

        return $instagram_pics;
    }

    public function requireAssets(array $libraries)
    {
        foreach ($libraries as $library) {
            if ($assets = PrestashopAssetsLibraries::getAssetsLibraries($library)) {
                foreach ($assets as $asset) {
                    $this->context->controller->{$asset['type']}($library, $asset['path'], $asset['params']);
                }
            }
        }
    }

    public static function getAccountInfos()
    {
        $access_token = Configuration::get('CS_INS_CT');
        $url = 'https://graph.instagram.com/me?fields=id,username&access_token='.$access_token;
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $json = curl_exec($ch);
        curl_close($ch);

        return json_decode($json, true);
    }

}
