<?php
/**
 * imageregenerator administration module version 1.2 for Prestashop 1.5, 1.6
 * Support contact : prestashop@comonsoft.com.
 *
 * NOTICE OF LICENSE
 *
 * This source file is the property of Jérémy Beson - Com'onSoft
 * that is bundled with this package.
 * It is also available through the world-wide-web at this URL:
 * https://boutique.comonsoft.com/
 *
 * @category  administration
 * @package   imageregenerator
 * @author   Jérémy Beson - Com'onSoft (https://www.comonsoft.com/)
 * @copyright 2016-2021 Com'onSoft and contributors
 * @version   1.3.3
 */

if (!defined('_PS_VERSION_'))
	exit;

class ImageRegenerator extends Module
{
	private $module_review_path;
	private $module_controller_url;
	private $product_shop_id;

	public function __construct()
	{
		$this->bootstrap = true;
		$this->name = 'imageregenerator';
		$this->tab = 'administration';
		$this->version = '1.3.6';
		$this->author = 'Jérémy Besson - ComonSoft';
		$this->need_instance = 0;
		$this->ps_versions_compliancy = array('min' => '1.5');

		parent::__construct();

		$this->displayName = $this->l('Image Regenerator', 'imageregenerator');
		$this->description = $this->l('Use ajax to regenerate image safely.', 'imageregenerator');

		$this->confirmUninstall = $this->l('Are you sure you want to uninstall?', 'imageregenerator');

		$this->module_review_path = _PS_MODULE_DIR_.'/'.$this->name.'/views/templates/admin/post-review-modal.tpl';
		$this->module_controller_url = __PS_BASE_URI__.'module/'.$this->name.'/AddModuleReviews';
		$this->product_shop_id = 27;
		$this->controllers = array('AddModuleReviews');

	}

	public function install()
	{
		if (parent::install() == false || !$this->registerHook('actionAdminControllerSetMedia') || !$this->registerHook('displayBackOfficeHeader'))
			return false;
		Configuration::updateValue('CS_IMAGEREGENERATOR_REVIEW', 0);
		return true;
	}

    public function uninstall()
    {
        if (!parent::uninstall()) {
            return false;
        }
		Configuration::deleteByName('CS_IMAGEREGENERATOR_REVIEW');

        return true;
    }

	public function hookDisplayBackOfficeHeader()
	{
		if((strtolower(Tools::getValue('controller')) == 'adminmodules') && (Tools::getValue('configure') == $this->name)) {
			$this->context->controller->addJquery();
			$this->context->controller->addCSS($this->getPathUri().'/views/css/productcomments.css');
			$this->context->controller->addJS($this->getPathUri().'//views/js/jquery.rating.plugin.js');
			$this->context->controller->addJS($this->getPathUri().'/views/js/post-comment.js');
		}
	}

	public function hookActionAdminControllerSetMedia()
	{
		if((Tools::getValue('controller') == 'AdminModules') && (Tools::getValue('configure') == $this->name)) {
			$this->context->controller->addJS(($this->_path).'js/ir-main.js');
			Media::addJsDef(array('ir_regenerate_str' => Tools::htmlentitiesUTF8($this->l('Regenerate', 'imageregenerator'))));
			Media::addJsDef(array('ir_success_str' => Tools::htmlentitiesUTF8($this->l('Success', 'imageregenerator'))));
			Media::addJsDef(array('ir_error_str' => Tools::htmlentitiesUTF8($this->l('Error', 'imageregenerator'))));
			Media::addJsDef(array('ir_finished_str' => Tools::htmlentitiesUTF8($this->l('Finished', 'imageregenerator'))));
		}
	}

	public function getContent()
	{
		$output = null;
		if (Tools::isSubmit('image_regenerator_queue'))
		{
			$image_regenerator_queue = strval(Tools::getValue('image_regenerator_queue'));
			$image_regenerator_queue_what = strval(Tools::getValue('image_regenerator_queue_what'));
			if($image_regenerator_queue_what && !empty($image_regenerator_queue_what)){
				Configuration::updateValue('image_regenerator_queue_what', $image_regenerator_queue_what);
			}
			if($image_regenerator_queue && !empty($image_regenerator_queue)){
				Configuration::updateValue('image_regenerator_queue', $image_regenerator_queue);
				$output .= $this->displayConfirmation($this->l('Queue saved', 'imageregenerator'));
			}
		}else if(Tools::isSubmit('image_regenerator_reinit')){
			$image_regenerator_reinit = strval(Tools::getValue('image_regenerator_reinit'));
			if($image_regenerator_reinit && !empty($image_regenerator_reinit)){
				Configuration::updateValue('image_regenerator_queue', '');
				$output .= $this->displayConfirmation($this->l('Queue cleared', 'imageregenerator'));
			}
		}

		$this->smarty->assign(array('moduleName' => $this->displayName, 
							'customer_name' => $this->context->employee->firstname.' '.substr($this->context->employee->lastname,0,1).'.',
							'module_review_path' => $this->module_review_path,
							'product_shop_id' => $this->product_shop_id,
							'domain' => urlencode(Context::getContext()->shop->getBaseURL(true)),
							'module_controller_url' => $this->module_controller_url));

		return $this->display(__FILE__,'views/templates/admin/infos.tpl').$output.$this->displayForm();
	}

	public function displayForm(){
		$images = Image::getAllImages();
		$r = '<div class="bootstrap">';
		$config = Configuration::get('image_regenerator_queue');
		$image_regenerator_queue_what = Configuration::get('image_regenerator_queue_what');
		$image_regenerator_queue_what = (empty($image_regenerator_queue_what))? "null" : '"'.$image_regenerator_queue_what.'"';
		if($config){
			$list = json_decode($config,true);
			if(!is_array($list) || count($list)==0){
				$list = false;
			}
		}
		else
			$list = false;

		if(!$list){
			$list = array();
			$process =
			array(
				array('type' => 'categories', 'dir' => _PS_CAT_IMG_DIR_),
				array('type' => 'manufacturers', 'dir' => _PS_MANU_IMG_DIR_),
				array('type' => 'suppliers', 'dir' => _PS_SUPP_IMG_DIR_),
				array('type' => 'products', 'dir' => _PS_PROD_IMG_DIR_),
				array('type' => 'stores', 'dir' => _PS_STORE_IMG_DIR_)
				);
			if( defined('_PS_SCENE_IMG_DIR_') ) {
				$process[] = array('type' => 'scenes', 'dir' => _PS_SCENE_IMG_DIR_);
			}
			foreach ($process as $proc)
			{
				$list[$proc["type"]] = array("todo"=>array(),"done"=>array(),"errors"=>array());
				if($proc["type"]=="products"){
					foreach($images as $img){
						$list['products']["todo"][] = $img['id_image'];
					}
				}else{
					$scanned_directory = array_diff(scandir($proc['dir']), array('..', '.'));
					foreach ($scanned_directory as $image){
						if (preg_match('/^[0-9]*\.jpg$/', $image)){
							$list[$proc["type"]]["todo"][] = $image;
						}
					}
				}
			}
		}
		
		$textHIW = $this->l('You can regenerate all your images safely.', 'imageregenerator');
		$r.='
		<div class="panel">
			<h3>'.$this->l('Let\'s go', 'imageregenerator').'</h3>
			<p>'.$textHIW.'</p>
			<div class="clearfix"></div>
			<table width="100%" id="autoImg-buttons"></table>
			<div class="clearfix"></div>
			<div class="btn-toolbar" role="toolbar" style="padding-top:20px">
				<div class="btn-group">
					<button class="btn btn-primary" id="image_regenerator-pause"><span class="icon-pause"></span>&nbsp;'.$this->l('PAUSE', 'imageregenerator').'</button>
					 <button class="btn btn-success" id="image_regenerator-resume"><span class="icon-play"></span> '.$this->l('RESUME', 'imageregenerator').'</button>
				</div>
				<div class="btn-group">
					<form method="post" id="image_regenerator_save_form">
						<input type="hidden" name="image_regenerator_queue_what" value=""/>
						<input type="hidden" name="image_regenerator_queue" value=""/>
					</form>
				</div>
				<div class="btn-group">
					<form method="post">
						<input type="hidden" name="image_regenerator_reinit" value="1"/>
						<button type="submit" class="btn btn-warning" id="image_regenerator-reinit"><span class="icon-recycle"></span> '.$this->l('RESET', 'imageregenerator').'</button>
					</form>
				</div>
				<div class="btn-group">
					<div class="checkbox">
						<label><input type="checkbox" value="1" id="image_regenerator-watermark"> '.$this->l('Watermark ? (module watermark need to be enable)', 'imageregenerator').'</label>
					</div>
				</div>
			</div>
		</div>
		<div class="panel"><h3>'.$this->l('Debug', 'imageregenerator').'</h3><div id="autoImg-progress" style="width:100%;line-height:20px;height:60px;overflow:auto;"></div><br/><div class="clearfix"></div>
		<script>var image_regenerator_can_run_queue = true;var image_regenerator_queuing_what = '.$image_regenerator_queue_what.';
		var autoImg = $.parseJSON(\''.json_encode($list).'\');
		var autoImgPath = "'.$this->context->link->getAdminLink('AdminModules').'&configure='.$this->name.'";
		</script></div></div>';
		return $r;
	}

	function ajaxProcessRegenerateMethod(){
		$process =array( 'categories' => _PS_CAT_IMG_DIR_,
			'manufacturers' => _PS_MANU_IMG_DIR_,
			'suppliers' => _PS_SUPP_IMG_DIR_,
			'products' => _PS_PROD_IMG_DIR_,
			'stores' => _PS_STORE_IMG_DIR_
			);
		if( defined('_PS_SCENE_IMG_DIR_') ) {
			$process[] = array('type' => 'scenes', 'dir' => _PS_SCENE_IMG_DIR_);
		}

		$baseType = Tools::getValue('type');
		$type = ImageType::getImagesTypes($baseType);
		$image = Tools::getValue('image');
		$watermark = (int) Tools::getValue('watermark');
		$dir = $process[$baseType];
		$success = null;
		$errors = null;
		$watermarked = 0;
		if($baseType!="products"){
			if (preg_match('/^[0-9]*\.jpg$/', $image)){
				foreach ($type as $k => $imageType)
				{
					// Customizable writing dir
					$newDir = $dir;
					if ($imageType['name'] == 'thumb_scene')
						$newDir .= 'thumbs/';
					if (!file_exists($newDir))
						$errors = sprintf( $this->l('Directory does not exist (%s)', 'imageregenerator'), $newDir);
					$newFile = $newDir.substr($image, 0, -4).'-'.stripslashes($imageType['name']).'.jpg';
					if(file_exists($newFile) && !unlink($newFile))
						$errors = sprintf( $this->l('Cannot delete file (%s)', 'imageregenerator'), $newFile);
					if (!file_exists($newFile))
					{

						if (!file_exists($dir.$image) || !filesize($dir.$image))
						{
							$errors = sprintf( $this->l('Source file does not exist or is empty (%s)', 'imageregenerator'), $dir.$image);
						}
						elseif (!ImageManager::resize($dir.$image, $newFile, (int)$imageType['width'], (int)$imageType['height']))
						{
							$errors = sprintf($this->l('Original image is corrupt (%s) or bad permission on folder or memory exhausted', 'imageregenerator'), $dir.$image);
						}else{
							$success = 1;
						}
					}else{
						$errors = sprintf( $this->l('Cannot delete file (%s)', 'imageregenerator'), $newFile);;
					}
				}
			}else{
				$success=1;
			}
		}else{
			$imageObj = new Image($image);
			$existing_img = $dir.$imageObj->getExistingImgPath().'.jpg';
			if (file_exists($existing_img) && filesize($existing_img))
			{
				if($watermark == 1){
					$watermarked = 1;
					$watermark = ModuleCore::getInstanceByName("watermark");
					if( is_object($watermark) ) {
						$valid_types = array();
						$watermark_types = explode(',', Configuration::get('WATERMARK_TYPES'));
						foreach($type as $k => $t){
							if(in_array($t['id_image_type'],$watermark_types)){
								$valid_types[] = $t;
								unset($type[$k]);
							}
						}
						$res = $watermark->hookActionWatermark(array('image_type'=>$valid_types,'id_image'=>$imageObj->id_image,'id_product'=>$imageObj->id_product));
					}
					else {
						$res= Hook::exec('actionWatermark', ['id_image' => $imageObj->id_image, 'id_product' => $imageObj->id_product]);
					}
					if( $res ){
						$success = 1;
					}else{
						$errors = sprintf($this->l('Error generating watermark on file (%s)', 'imageregenerator'), $existing_img);
					}
				}
				if(count($type)>0){
					foreach ($type as $imageType){
						$newFile = $dir.$imageObj->getExistingImgPath().'-'.stripslashes($imageType['name']).'.jpg';
						if(file_exists($newFile) && !unlink($newFile))
							$errors = 1;
						if (!file_exists($newFile)){
							if (!ImageManager::resize($existing_img, $newFile, (int)($imageType['width']), (int)($imageType['height'])))
							{
								$errors = sprintf($this->l('Original image is corrupt (%s) or bad permission on folder or memory exhausted', 'imageregenerator'), $existing_img);
							}else{
								$success = 1;
							}
						}else{
							$errors = sprintf($this->l('Cannot delete file (%s) or bad permission on folder/file', 'imageregenerator'), $existing_img);
						}
					}
				}
			}
			else
			{
				$errors = sprintf($this->l('Original image is missing or empty (%s)', 'imageregenerator'), $existing_img);
			}
		}
		echo json_encode(array('success'=>$success,'error'=>$errors,'watermark'=>$watermarked));
		exit;
	}
}
