<?php
/**
 * csoft_clearcache back office module for Prestashop >= 1.7
 * Support contact : support@comonsoft.com.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * This source file has been created by Com'onSoft.
 * It is also available through the world-wide-web at this URL:
 * https://boutique.comonsoft.com/
 *
 * @category  back office
 * @package   csoft_clearcache
 * @author    Com'onSoft (https://www.comonsoft.com/)
 * @copyright 2025 Com'onSoft
**/
class Csoft_clearcacheAddModuleReviewsModuleFrontController extends ModuleFrontController {

  public function display(){

	/** Validate all Posted data */
	$id_product = (int) Tools::getValue('id_product');
	if(!Validate::isGenericName($id_product) || !Validate::isCleanHtml($id_product))
	  return false;

	$comment_content = Tools::getValue('comment_content');
	if(!Validate::isGenericName($id_product) || !Validate::isCleanHtml($id_product))
	  return false;

	$customer_name = Tools::getValue('customer_name');
	if(!Validate::isGenericName($customer_name) || !Validate::isCleanHtml($customer_name))
	  return false;

	$criterions = Tools::getValue('criterion');
	if(!Validate::isGenericName($criterions) || !Validate::isCleanHtml($criterions))
	  return false;

	$url = 'https://boutique.comonsoft.com/fr/module/csoft_save_modules_reviews/SaveModuleReviews';
	$parameters = array('id_product' => $id_product, 'comment_content' => $comment_content, 'customer_name' => $customer_name, 'criterion' => $criterions);

	$encoded = '';
	foreach($parameters as $name => $value) {
	  $encoded .= urlencode($name).'='.urlencode($value).'&';
	}
	$encoded = substr($encoded, 0, strlen($encoded)-1);

	$ch = curl_init($url);
	curl_setopt($ch, CURLOPT_POSTFIELDS,  $encoded);
	curl_setopt($ch, CURLOPT_POST, true);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	$json = curl_exec($ch);
	curl_close($ch);

	$this->ajaxDie($json);
	die;
  }
}
?>