<?php
/**
 * csoft_clearcache back office module for Prestashop >= 1.7
 * Support contact : support@comonsoft.com.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * This source file has been created by Com'onSoft.
 * It is also available through the world-wide-web at this URL:
 * https://boutique.comonsoft.com/
 *
 * @category  back office
 * @package   csoft_clearcache
 * @author    Com'onSoft (https://www.comonsoft.com/)
 * @copyright 2025 Com'onSoft
**/
 

if (!defined('_PS_VERSION_')) {
    exit;
}

use PrestaShop\PrestaShop\Adapter\SymfonyContainer;

class Csoft_clearcache extends Module
{
    private $module_review_path;
    private $module_controller_url;
    private $product_shop_id;

    public function __construct() {
        $this->name = 'csoft_clearcache';
        $this->version = '1.0.0';
        $this->tab = 'administration';
        $this->author = 'ComonSoft';
        $this->need_instance = 0;
        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->l('Clear cache menu');
        $this->description = $this->l('Clear cache in any back office page. Add a cache menu to the top bar of the back office, to empty different kinds of caches.');
        $this->confirmUninstall = $this->l('Are you sure you want to uninstall this module?');

        $this->ps_versions_compliancy = array('min' => '1.7.0.0', 'max' => _PS_VERSION_);

        $this->module_review_path = _PS_MODULE_DIR_.'/'.$this->name.'/views/templates/admin/post-review-modal.tpl';
        $this->module_controller_url = __PS_BASE_URI__.'module/'.$this->name.'/AddModuleReviews';
        $this->product_shop_id = 56;

    }

    public function install() {
        return parent::install()
               && $this->registerHook('displayBackOfficeHeader')
               && $this->registerHook('actionAdminControllerSetMedia')
               && $this->registerHook('displayBackOfficeTop');
    }

    public function getContent()
    {

        $this->smarty->assign( array('moduleName' => $this->displayName, 
									'customer_name' => $this->context->employee->firstname.' '.substr($this->context->employee->lastname,0,1).'.',
									'module_review_path' => $this->module_review_path,
									'product_shop_id' => $this->product_shop_id, 
									'module_controller_url' => $this->module_controller_url,
									'domain' => urlencode(Context::getContext()->shop->getBaseURL(true))
									)
							);

        return $this->display(__FILE__, 'views/templates/admin/infos.tpl');
    }

    public function hookDisplayBackOfficeTop($params) {
        // get clear cache url
        $cachesf_url = '';
        $sfc = SymfonyContainer::getInstance();
        if (!is_null($sfc)) {
            $router = $sfc->get('router');
            $cachesf_url = $router->generate('admin_clear_cache');
        }

        $this->smarty->assign(array(
            'all' => $cachesf_url,
			'smarty' => $this->context->link->getAdminLink('AdminAjaxcsoft_clearcache', true, [], ['ajax' => 1, 'action' => 'smarty']),
			'css' => $this->context->link->getAdminLink('AdminAjaxcsoft_clearcache', true, [], ['ajax' => 1, 'action' => 'css']),
			'js' => $this->context->link->getAdminLink('AdminAjaxcsoft_clearcache', true, [], ['ajax' => 1, 'action' => 'js']),
			'cssjs' => $this->context->link->getAdminLink('AdminAjaxcsoft_clearcache', true, [], ['ajax' => 1, 'action' => 'cssjs']),
			'home' => $this->context->link->getAdminLink('AdminAjaxcsoft_clearcache', true, [], ['ajax' => 1, 'action' => 'home'])
            ));

        return $this->display(__FILE__, '/views/templates/admin/menu.tpl');
    }

    public function hookActionAdminControllerSetMedia() {
        $this->context->controller->addCss($this->_path . '/views/css/admin/clearcache.css');
    }

    public function hookDisplayBackOfficeHeader()
    {
        if((strtolower(Tools::getValue('controller')) == 'adminmodules') && (Tools::getValue('configure') == $this->name)) {
            $this->context->controller->addJquery();
            $this->context->controller->addCSS($this->getPathUri().'views/css/admin/productcomments.css');
            $this->context->controller->addJS($this->getPathUri().'views/js/admin/jquery.rating.plugin.js');
            $this->context->controller->addJS($this->getPathUri().'views/js/admin/post-comment.js');
        }
    }

}
